#pragma once

#include <cstdint>
#include <string>
#include <array>

namespace openplx {

    enum class UuidVersion {
        V4,
        V5
    };

    struct UuidSettings {
        UuidVersion version;
        std::string uuidv5_namespace_id;
    };

    class UuidGenerator {
        public:
            static std::string generateNilUuid();
            static bool isUuidStr(std::string uuid_str);
            static std::array<uint8_t, 16> parseUuid(std::string uuid_str);
            static std::string generateUuid(const UuidSettings& settings, std::string name);
            static std::string generateUuidv4();
            static std::string generateUuidv5(std::string namespace_id, std::string name);
    };
}
