#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Sensors/LidarLogic.h>
#include <openplx/Physics/Signals/Marshalling.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LidarOutput */
namespace openplx::Sensors::Signals {
    class OPENPLX_Sensors_BUNDLE_EXPORT LidarOutput : public openplx::Physics::Signals::Output {
        protected:
            std::vector<int64_t> m_fields;
            std::weak_ptr<openplx::Sensors::LidarLogic> m_source;

        public:
            LidarOutput();
            virtual ~LidarOutput();
            std::vector<int64_t> fields() const;
            std::shared_ptr<openplx::Sensors::LidarLogic> source() const;
            static std::shared_ptr<openplx::Physics::Signals::Marshalling> marshalling_from_fields(std::vector<int64_t> fields);
            std::vector<double> readTimeStamps(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<std::shared_ptr<openplx::Math::Vec3>> readPositions(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<double> readDistances(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<std::shared_ptr<openplx::Math::Matrix4x4>> readRayPoses(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<bool> readIsHits(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<double> readIntensities(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<std::int64_t> readEntityIds(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal> createSignal(const std::vector<double>& time_stamps, const std::vector<std::shared_ptr<openplx::Math::Vec3>>& positions, const std::vector<double>& distances, const std::vector<std::shared_ptr<openplx::Math::Matrix4x4>>& ray_poses, const std::vector<bool>& is_hits, const std::vector<double>& intensities, const std::vector<std::int64_t>& entityIds) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
