#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/GyroscopeSensingDistortion.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model GyroscopeSignalSpectralGaussianNoise */
namespace openplx::Sensors {
    /**
     *     A spectral noise error affecting the measured gyroscope signal based on its sampling
     *     frequency.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT GyroscopeSignalSpectralGaussianNoise : public openplx::Sensors::GyroscopeSensingDistortion {
        protected:
            double m_noise_density_x;
            double m_noise_density_y;
            double m_noise_density_z;

        public:
            GyroscopeSignalSpectralGaussianNoise();
            virtual ~GyroscopeSignalSpectralGaussianNoise();
            double noise_density_x() const;
            double noise_density_y() const;
            double noise_density_z() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
