#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/StructuralComponent.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SuctionCup */
namespace openplx::Robotics::EndEffectors {
    /**
     * A suction cup has object_connector at its origin with the purpose
     * to use SNAP position objects at the lip of the cup.
     * The characteristics of the flexible cup are considered to be different in the relaxed and collapsed state.
     * Therefore there are two mate connectors for attaching the cup to the vacuum gripper.
     * It is up to the runtime environment to swap between two states, both should not be active simultaneously.
     *
     * The mounting_radius define the area for airflow through the top of the cup.
     * The lip_radius define the area for gripping.
     * The resting_height is the height of the cup when not exposed to any external forces.
     * The collapsed_height is the height of the cup when an object is grasped, and the cup has collapsed.
     *
     * The body of the gripper_connector should point to the body of the gripper to which the cup is connected.
     *
     * The origin of the body shold be at the surface of the imagined lip of the cup.
     * The local body position is by default at negative resting_height relative the cup system along the lip_normal.
     * The local_transform of the cup relative its parent system, i.e. the gripper, is required for positioning it.
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT SuctionCup : public openplx::Physics3D::StructuralComponent {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            double m_lip_radius;
            double m_mounting_radius;
            double m_resting_height;
            double m_collapsed_height;
            std::shared_ptr<openplx::Math::Vec3> m_lip_normal;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_gripper_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_resting_mounting_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_collapsed_mounting_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_object_connector;

        public:
            SuctionCup();
            virtual ~SuctionCup();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            double lip_radius() const;
            double mounting_radius() const;
            double resting_height() const;
            double collapsed_height() const;
            std::shared_ptr<openplx::Math::Vec3> lip_normal() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> gripper_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> resting_mounting_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> collapsed_mounting_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> object_connector() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
