#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics3D/Signals/Torque3DOutputTrait.h>
#include <openplx/Physics3D/Signals/Vec3Marshalling.h>
#include <openplx/Math/AffineTransform.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Torque3DOutput */
namespace openplx::Physics3D::Signals {
    /**
     * A 3D Torque output given an interaction.
     * For interactions where it is unambiguous which torque is requested,
     * the output will give the current output value.
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT Torque3DOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics3D::Signals::Torque3DOutputTrait> m_source;
            std::optional<std::weak_ptr<openplx::Math::AffineTransform>> m_relative_to;

        public:
            Torque3DOutput();
            virtual ~Torque3DOutput();
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutputTrait> source() const;
            std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling> marshalling() const;
            std::optional<std::shared_ptr<openplx::Math::AffineTransform>> relative_to() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
