#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DOutputTrait.h>
#include <openplx/Physics3D/Signals/Vec3Marshalling.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LinearVelocity3DOutput */
namespace openplx::Physics3D::Signals {
    /**
     * A vec3 as linear velocity output.
     * For models where it is unambiguous which linear velocity that is requested,
     * the output will give the current output value.
     * The output is given as a 3D velocity vector in the world coordinate system, expressed in absolute coordinates.
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT LinearVelocity3DOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutputTrait> m_source;

        public:
            LinearVelocity3DOutput();
            virtual ~LinearVelocity3DOutput();
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutputTrait> source() const;
            std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling> marshalling() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
