#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutputTrait.h>
#include <openplx/Physics/Signals/Position1DOutputTrait.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutputTrait.h>
#include <openplx/Physics3D/Signals/Force3DOutputTrait.h>
#include <openplx/Physics3D/Signals/Torque3DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultCylindricalDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultCylindricalFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultCylindricalToughness.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>
#include <openplx/Physics/Signals/AngleOutput.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutput.h>
#include <openplx/Physics/Signals/Position1DOutput.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutput.h>
#include <openplx/Physics3D/Signals/Torque3DOutput.h>
#include <openplx/Physics3D/Signals/Force3DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Cylindrical */
namespace openplx::Physics3D::Interactions {
    /**
     *     A cylindrical which constrain four degrees of freedom between two bodies.
     *     The rotation around and translation along the main axis of the two connectors is free.
     *     The translational friction along and rotational friction around the axis may be specified.
     *
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT Cylindrical : public openplx::Physics3D::Interactions::Mate, public openplx::Physics::Signals::AngleOutputTrait, public openplx::Physics::Signals::AngularVelocity1DOutputTrait, public openplx::Physics::Signals::Position1DOutputTrait, public openplx::Physics::Signals::LinearVelocity1DOutputTrait, public openplx::Physics3D::Signals::Force3DOutputTrait, public openplx::Physics3D::Signals::Torque3DOutputTrait {
        protected:
            double m_initial_angle;
            double m_initial_position;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction_translational;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction_rotational;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_angle_output;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> m_angular_velocity_output;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> m_position_output;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> m_velocity_output;
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> m_force_output;

        public:
            Cylindrical();
            virtual ~Cylindrical();
            double initial_angle() const;
            double initial_position() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness> toughness() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction_translational() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction_rotational() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> angle_output() const;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> angular_velocity_output() const;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> position_output() const;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> velocity_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
