#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Torque1DOutput */
namespace openplx::Physics::Signals {
    /**
     * A scalar Torque output given an interaction.
     * For interactions where it is unambiguous which torque is requested,
     * the output will give the current output value.
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT Torque1DOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics::Signals::Torque1DOutputTrait> m_source;

        public:
            Torque1DOutput();
            virtual ~Torque1DOutput();
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
