#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
/* Generated code for model OrenNayarReflectionModel */
namespace openplx::Physics::Optics::Surfaces::Traits {
    /**
     *     A trait allowing the addition of a rough diffuse Oren-Nayar reflection to the surface of a
     *     geometry.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT OrenNayarReflectionModel {
        public:
            OrenNayarReflectionModel();
            virtual ~OrenNayarReflectionModel();
            virtual double diffuse_reflectivity() const = 0;
            virtual double oren_nayar_roughness() const = 0;
    };
}
