#pragma once

#include <memory>
#include <openplx/Node.h>
#include <openplx/CompositeType.h>

namespace openplx {

    class OrType : public CompositeType, public std::enable_shared_from_this<OrType>
    {
        public:
            /* Factories */
            static OrTypePtr create(
                const std::vector<TypePtr>& types);

            /* Overrides */
            OrTypePtr asOrType() override;
            TypePtr asType() override;
            CompositeTypePtr asCompositeType() override;
            void accept(NodeVisitor& visitor) override;
            bool isAssignableTo(const TypePtr &other) override;
            std::string toString() override;
            std::string toKey() override;
            TypePtr resolve() override;
            void unbind() override;

            bool isEmpty() const override;
            VarAssignPtr findFirstMemberWithType(const std::string& name) const override;
            VarAssignPtr lookupDeclaration(const std::string& symbol_path) override;
            VarAssignPtr lookupDeclarationFromSegments(const std::vector<Token>& segments, size_t first_ix, size_t last_ix) override;

            /* Types */
            const std::vector<TypePtr>& getTypes() const;
            void appendToTypes(TypePtr type_instance);

            /* Common parent */
            void setCommonParent(ModelDeclPtr common_parent);
            ModelDeclPtr getCommonParent() const;

        private:
            OrType();
            std::vector<TypePtr> m_types;
            ModelDeclPtr m_common_parent;
    };
}
