#pragma once

#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/ModelDeclaration.h>
#include <openplx/VarAssignment.h>
#include <openplx/Expression.h>

namespace openplx {
    class NodeBuilder {
        public:
            static ExprPtr reference(const std::vector<Token>& segments);
            static ExprPtr reference(const std::vector<std::string>& segments);
    };

    class ModelDeclBuilder
    {
        public:
            ModelDeclBuilder();
            ModelDeclBuilder withQualifierToken(Token qualifier_token);
            ModelDeclBuilder withName(std::string name);
            ModelDeclBuilder withNameToken(Token name_token);
            ModelDeclBuilder withParentSegments(std::vector<Token> parent_segments);
            ModelDeclBuilder withParentSegments(std::string parent_segments);
            ModelDeclBuilder withAnnotation(AnnotationPtr annotation);
            ModelDeclBuilder withAnnotations(std::vector<AnnotationPtr> annotations);
            ModelDeclBuilder withTrait(TraitImplPtr trait);
            ModelDeclBuilder withTraits(std::vector<TraitImplPtr> traits);
            ModelDeclBuilder withDeletion(DeletionPtr deletion);
            ModelDeclBuilder withDeletions(std::vector<DeletionPtr> deletions);
            ModelDeclBuilder withMember(NodePtr member);
            ModelDeclBuilder withMembers(std::vector<NodePtr> members);
            ModelDeclPtr build();
        private:
            Token m_qualifier_token;
            Token m_name_token;
            std::vector<Token> m_parent_segments;
            std::vector<AnnotationPtr> m_annotations;
            std::vector<TraitImplPtr> m_traits;
            std::vector<DeletionPtr> m_deletions;
            std::vector<NodePtr> m_members;
    };

    class AttrDeclBuilder
    {
        public:
            AttrDeclBuilder();
            AttrDeclBuilder withTargetModifier(Token target_modifier);
            AttrDeclBuilder withTargetSegments(std::vector<Token> target_segments);
            AttrDeclBuilder withTargetSegments(std::string target_segments);
            AttrDeclBuilder withTypeModifier(Token type_modifier);
            AttrDeclBuilder withIs();
            AttrDeclBuilder withBecomes();
            AttrDeclBuilder withTypeSegments(std::vector<Token> type_segments);
            AttrDeclBuilder withTypeSegments(std::string type_segments);
            AttrDeclBuilder withTypeSegment(Token type_segment);
            AttrDeclBuilder withPostModifier(Token post_modifier);
            AttrDeclBuilder withAnnotation(AnnotationPtr annotation);
            AttrDeclBuilder withAnnotations(std::vector<AnnotationPtr> annotations);
            AttrDeclBuilder withMember(VarAssignPtr member);
            AttrDeclBuilder withMembers(std::vector<VarAssignPtr> members);
            AttrDeclBuilder withValue(ExprPtr value);
            VarAssignPtr build();

        private:
            Token m_target_modifier;
            std::vector<Token> m_target_segments;
            Token m_type_modifier;
            std::vector<Token> m_type_segments;
            Token m_post_modifier;
            std::vector<AnnotationPtr> m_annotations;
            std::vector<VarAssignPtr> m_members;
            ExprPtr m_value;
    };
}
