#pragma once

#include <vector>
#include <string>
#include <openplx/Error.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

namespace openplx {

    class OPENPLX_CORE_EXPORT ErrorReporter {
        public:
            ~ErrorReporter() = default;

            void reportError(std::shared_ptr<Error> error);
            /**
             * @deprecated will be moved to subclass
             */

            Errors::const_iterator begin() const;

            Errors::const_iterator end() const;

            size_t getErrorCount() const;
            const Errors& getErrors() const;
            void clear();

        private:
            Errors m_errors;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
