#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/DriveTrain/Shaft.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/DriveTrain/GearBox.h>
#include <openplx/DriveTrain/ManualClutch.h>
#include <openplx/DriveTrain/Differential.h>
#include <openplx/DriveTrain/ManualBrake.h>
#include <openplx/DriveTrain/Actuator.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TwoWheelTemplate */
namespace openplx::DriveTrain::MechanicalDriveTrains {
    class OPENPLX_DriveTrain_BUNDLE_EXPORT TwoWheelTemplate : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::DriveTrain::Shaft> m_engine_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_gear_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_clutch_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_diff_left_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_diff_right_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_left_brake_shaft;
            std::shared_ptr<openplx::DriveTrain::Shaft> m_right_brake_shaft;
            std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF> m_engine;
            std::shared_ptr<openplx::DriveTrain::GearBox> m_gear_box;
            std::shared_ptr<openplx::DriveTrain::ManualClutch> m_clutch;
            std::shared_ptr<openplx::DriveTrain::Differential> m_differential;
            std::shared_ptr<openplx::DriveTrain::ManualBrake> m_left_brake;
            std::shared_ptr<openplx::DriveTrain::ManualBrake> m_right_brake;
            std::shared_ptr<openplx::DriveTrain::Actuator> m_left_actuator;
            std::shared_ptr<openplx::DriveTrain::Actuator> m_right_actuator;

        public:
            TwoWheelTemplate();
            virtual ~TwoWheelTemplate();
            std::shared_ptr<openplx::DriveTrain::Shaft> engine_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> gear_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> clutch_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> diff_left_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> diff_right_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> left_brake_shaft() const;
            std::shared_ptr<openplx::DriveTrain::Shaft> right_brake_shaft() const;
            std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF> engine() const;
            std::shared_ptr<openplx::DriveTrain::GearBox> gear_box() const;
            std::shared_ptr<openplx::DriveTrain::ManualClutch> clutch() const;
            std::shared_ptr<openplx::DriveTrain::Differential> differential() const;
            std::shared_ptr<openplx::DriveTrain::ManualBrake> left_brake() const;
            std::shared_ptr<openplx::DriveTrain::ManualBrake> right_brake() const;
            std::shared_ptr<openplx::DriveTrain::Actuator> left_actuator() const;
            std::shared_ptr<openplx::DriveTrain::Actuator> right_actuator() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
