#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutputTrait.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/FractionOutputTrait.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutput.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/FractionInput.h>
#include <openplx/Physics/Signals/FractionOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ManualClutch */
namespace openplx::DriveTrain {
    /**
     * Single disk plate clutch with dry friction. Input and output shafts are
     * connected to plates with rough surfaces.  A spring loaded mechanism increases
     * the normal force between the plates between a minimum and maximum, giving rise
     * to the concept of torque capacity.  When the plates are at maximum distance
     * from each other, no force is transmitted.  When they are at zero distance,
     * maximum pressure is applied.
     *
     * Together with Coulomb friction, this keeps the plates rotating at nearly the
     * same angular velocity untill the stick-slip transition is reached,
     * alternately, when the torque required to move the output shaft at the same
     * velocity as the input shaft reaches the torque capacity.  This happens when
     * the load on the output shaft is too difficult to move.  If the two disks move
     * relative to each other, this is called slipping and is measured with a
     * ClutchSlipVelocity1DOutput at any time.
     *
     * The engagement_fraction here represents the value of the torque capacity in
     * proportion to the maximum capacity, i.e., when the plates are fully closed,
     * i.e., maximum normal force is achieved.  As for most clutches, this model
     * includes a "locked" mode in which a clamp is activated to prevent any slip.
     * This stays "ON" until the clutch is disengaged, or if the output shaft starts
     * to move faster but in the same direction as the input shaft, as in the case of
     * dynamic breaking.
     *
     * For a small enough relative slip ratio, when the slip velocity is small
     * in proportion to the input shaft velocity, defined by min_relative_slip_ratio.
     * The copuling is considered perfect, and no slip is anymore possible.
     * The Clutch may slip again either when it is disengaged or when
     * the clutch torque is negative -> dynamic braking.
     **/
    class OPENPLX_DriveTrain_BUNDLE_EXPORT ManualClutch : public openplx::Physics1D::Interactions::Mate, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::RelativeVelocity1DOutputTrait, public openplx::Physics::Signals::FractionInputTrait, public openplx::Physics::Signals::FractionOutputTrait {
        protected:
            double m_initial_engagement_fraction;
            double m_torque_capacity;
            double m_min_relative_slip_ratio;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> m_slip_velocity_output;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_engagement_fraction_input;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> m_engagement_fraction_output;

        public:
            ManualClutch();
            virtual ~ManualClutch();
            double initial_engagement_fraction() const;
            double torque_capacity() const;
            double min_relative_slip_ratio() const;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> slip_velocity_output() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> engagement_fraction_input() const;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> engagement_fraction_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
