#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CatC17520 */
namespace openplx::DriveTrain::Engines {
    /**
     *         Used in CAT 797F. https://en.wikipedia.org/wiki/Caterpillar_797 https://www.cat.com/en_US/products/new/equipment/off-highway-trucks/mining-trucks/18093014.html
     *         Reference: https://en.wikipedia.org/wiki/Caterpillar_C175
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT CatC17520 : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            CatC17520();
            virtual ~CatC17520();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
