#pragma once

#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>

namespace openplx {

    /**
     * CompositeType is an abstract base class for nodes that represent composite types
     * for example ModelDeclaration and WithType. A composite type is a type that can
     * be composed of arbitrarily complex components, in OpenPLX it mostly means that
     * it can contain nested declarations. Reference: https://en.wikipedia.org/wiki/Composite_data_type
     */
    class CompositeType : public Type {
        public:

            virtual bool isEmpty() const = 0;

            virtual VarAssignPtr findFirstMemberWithType(const std::string& name) const = 0;
            virtual VarAssignPtr lookupDeclaration(const std::string& symbol_path) = 0;
            virtual VarAssignPtr lookupDeclarationFromSegments(const std::vector<Token>& segments, size_t first_ix, size_t last_ix) = 0;

        protected:
            CompositeType(NodeType type);
    };
}
