
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/PrimitiveType.h>
#include <openplx/AnalysisContext.h>
#include <openplx/TreeNode.h>

namespace openplx {
    /**
     * Set's the type of all expressions using a SymbolTree for lookups
     */
    class BindExpressionTypesVisitor : private NodeVisitor {
        public:
            BindExpressionTypesVisitor(std::shared_ptr<Analysis::AnalysisContext> context, std::shared_ptr<ErrorReporter> error_reporter);
            void bind(OuterSymbolPtr symbol);
            void bind(DocPtr document);
            void bind(ModelDeclPtr model);
            void bind(VarAssignPtr var_assignment);
        private:
            void visitConstant(const ConstantPtr& constant) override;
            void visitCall(const CallPtr& call) override;
            void visitMemberAccess(const MemberAccessPtr& member_access) override;
            void visitArray(const ArrayPtr& array) override;
            void visitUnary(const UnaryPtr& unary) override;
            void visitBinaryOp(const BinaryOpPtr& binary_op) override;
            void visitIndexing(const IndexingPtr& indexing) override;
            void visitAnnotation(const AnnotationPtr& annotation) override;
            void visitTraitImpl(const TraitImplPtr& trait_impl) override;
            void visitInitializer(const InitializerPtr& initializer) override;

            template<typename ErrorType>
            void reportError(line_t line, col_t column);
            template<typename ErrorType>
            void reportError(const Token& first_token, const Token& last_token);
            template<typename ErrorType>
            void reportError(const Token& token);
            template<typename ErrorType>
            void reportError(const std::vector<Token>& segments);
            void reportError(std::shared_ptr<Error>&& error);

            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::shared_ptr<Analysis::AnalysisContext> m_context;
            DocPtr m_document;
            OuterSymbolPtr m_symbol;
            std::shared_ptr<TreeNode<OuterSymbol>> m_root;
            ModelDeclPtr m_root_model;

            PrimitiveTypePtr m_primitive_type_real;
            PrimitiveTypePtr m_primitive_type_string;
            PrimitiveTypePtr m_primitive_type_bool;
            PrimitiveTypePtr m_primitive_type_int;
            PrimitiveTypePtr m_primitive_type_none;
    };
}
