#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/AGX/AGXBundleExport.h>
#include <openplx/AGX/AGXForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Urdf/UrdfForward.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Terrain/Shovel.h>
#include <openplx/Math/Vec3.h>
#include <openplx/AGX/AGXTerrain/ExcavationModeData.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Shovel */
namespace openplx::AGX::AGXTerrain {
    class OPENPLX_AGX_BUNDLE_EXPORT Shovel : public openplx::Terrain::Shovel {
        protected:
            double m_penetration_depth_threshold;
            double m_penetration_force_scaling;
            double m_max_penetration_force;
            double m_vertical_blade_soil_merge_distance;
            bool m_enable_particle_free_deformers;
            bool m_enable_generate_teeth_geometry;
            bool m_enable_custom_teeth_geometry;
            std::shared_ptr<openplx::Math::Vec3> m_custom_teeth_geometry_half_vec;
            bool m_enable_excavation_at_teeth_edge;
            bool m_always_remove_shovel_contacts;
            bool m_enable_inner_shape_create_dynamic_mass;
            bool m_enable_particle_force_feedback;
            bool m_use_zero_aggregate_velocity;
            double m_no_merge_extension_distance;
            double m_minimum_submerged_contact_length_fraction;
            double m_secondary_separation_deadload_limit;
            double m_contact_region_threshold;
            double m_contact_region_vertical_limit;
            double m_particle_inclusion_multiplier;
            double m_custom_excavation_stiffness_multiplier;
            int64_t m_num_contact_patches;
            std::vector<double> m_custom_contact_patch_angle_tresholds;
            bool m_enable_custom_partitioning;
            bool m_enable_custom_forward_vector;
            bool m_enable_custom_bottom_vector;
            std::shared_ptr<openplx::Math::Vec3> m_custom_forward_vector;
            std::shared_ptr<openplx::Math::Vec3> m_custom_bottom_vector;
            bool m_enable_teeth_volume;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> m_primary_excavation_mode;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> m_back_excavation_mode;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> m_right_excavation_mode;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> m_left_excavation_mode;

        public:
            Shovel();
            virtual ~Shovel();
            double penetration_depth_threshold() const;
            double penetration_force_scaling() const;
            double max_penetration_force() const;
            double vertical_blade_soil_merge_distance() const;
            bool enable_particle_free_deformers() const;
            bool enable_generate_teeth_geometry() const;
            bool enable_custom_teeth_geometry() const;
            std::shared_ptr<openplx::Math::Vec3> custom_teeth_geometry_half_vec() const;
            bool enable_excavation_at_teeth_edge() const;
            bool always_remove_shovel_contacts() const;
            bool enable_inner_shape_create_dynamic_mass() const;
            bool enable_particle_force_feedback() const;
            bool use_zero_aggregate_velocity() const;
            double no_merge_extension_distance() const;
            double minimum_submerged_contact_length_fraction() const;
            double secondary_separation_deadload_limit() const;
            double contact_region_threshold() const;
            double contact_region_vertical_limit() const;
            double particle_inclusion_multiplier() const;
            double custom_excavation_stiffness_multiplier() const;
            int64_t num_contact_patches() const;
            std::vector<double> custom_contact_patch_angle_tresholds() const;
            bool enable_custom_partitioning() const;
            bool enable_custom_forward_vector() const;
            bool enable_custom_bottom_vector() const;
            std::shared_ptr<openplx::Math::Vec3> custom_forward_vector() const;
            std::shared_ptr<openplx::Math::Vec3> custom_bottom_vector() const;
            bool enable_teeth_volume() const;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> primary_excavation_mode() const;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> back_excavation_mode() const;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> right_excavation_mode() const;
            std::shared_ptr<openplx::AGX::AGXTerrain::ExcavationModeData> left_excavation_mode() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
