%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Sensors::AccelerometerLogic;
%nspace openplx::Sensors::AccelerometerSensingDistortion;
%nspace openplx::Sensors::AccelerometerSignalGaussianNoise;
%nspace openplx::Sensors::AccelerometerSignalSpectralGaussianNoise;
%nspace openplx::Sensors::Distortion;
%nspace openplx::Sensors::GyroscopeLogic;
%nspace openplx::Sensors::GyroscopeSensingDistortion;
%nspace openplx::Sensors::GyroscopeSignalGaussianNoise;
%nspace openplx::Sensors::GyroscopeSignalLinearAccelectionEffect;
%nspace openplx::Sensors::GyroscopeSignalSpectralGaussianNoise;
%nspace openplx::Sensors::Library::LIDARs::Ouster::OS0;
%nspace openplx::Sensors::Library::LIDARs::Ouster::OS1;
%nspace openplx::Sensors::Library::LIDARs::Ouster::OS2;
%nspace openplx::Sensors::Library::LIDARs::Ouster::OSDome;
%nspace openplx::Sensors::Library::LIDARs::SICK::TIM150;
%nspace openplx::Sensors::Library::LIDARs::SICK::TIM310;
%nspace openplx::Sensors::Library::LIDARs::SICK::TIM781;
%nspace openplx::Sensors::Library::LIDARs::Velodyne::VLP16;
%nspace openplx::Sensors::LidarDetectionDistanceGaussianNoise;
%nspace openplx::Sensors::LidarLogic;
%nspace openplx::Sensors::LidarSensingDistortion;
%nspace openplx::Sensors::MagnetometerLogic;
%nspace openplx::Sensors::MagnetometerSensingDistortion;
%nspace openplx::Sensors::MagnetometerSignalGaussianNoise;
%nspace openplx::Sensors::MagnetometerSignalSpectralGaussianNoise;
%nspace openplx::Sensors::Optics::BeamDivergence;
%nspace openplx::Sensors::Optics::ConicalBeamDivergence;
%nspace openplx::Sensors::Optics::HorizontalSweepRaySource;
%nspace openplx::Sensors::Optics::RayEmissionAngleGaussianNoise;
%nspace openplx::Sensors::Optics::RayEmissionDistortion;
%nspace openplx::Sensors::Optics::RaySource;
%nspace openplx::Sensors::Optics::Traits::BeamEmitter;
%nspace openplx::Sensors::Optics::Traits::DistortedRayEmission;
%nspace openplx::Sensors::Optics::Traits::LidarHorizontalResolution1024;
%nspace openplx::Sensors::Optics::Traits::LidarHorizontalResolution2048;
%nspace openplx::Sensors::Optics::Traits::LidarHorizontalResolution512;
%nspace openplx::Sensors::Optics::Traits::LidarVerticalResolution128;
%nspace openplx::Sensors::Optics::Traits::LidarVerticalResolution32;
%nspace openplx::Sensors::Optics::Traits::LidarVerticalResolution64;
%nspace openplx::Sensors::Optics::Traits::PulsedBeamEmitter;
%nspace openplx::Sensors::Optics::Traits::RayEmitter;
%nspace openplx::Sensors::PulsedLidarLogic;
%nspace openplx::Sensors::SensorLogic;
%nspace openplx::Sensors::Signals::AccelerometerOutput;
%nspace openplx::Sensors::Signals::GyroscopeOutput;
%nspace openplx::Sensors::Signals::LidarOutput;
%nspace openplx::Sensors::Signals::LidarOutputField;
%nspace openplx::Sensors::Signals::MagnetometerOutput;
%nspace openplx::Sensors::Signals::SensorOutputSignal;
%nspace openplx::Sensors::Signals::TriaxialOutputField;
%nspace openplx::Sensors::Traits::LidarFrequency05;
%nspace openplx::Sensors::Traits::LidarFrequency10;
%nspace openplx::Sensors::Traits::LidarFrequency15;
%nspace openplx::Sensors::Traits::LidarFrequency20;
%nspace openplx::Sensors::Traits::MateAttachment;
%nspace openplx::Sensors::Traits::MateConnectorAttachment;
%nspace openplx::Sensors::TriaxialRange;
%nspace openplx::Sensors::TriaxialSensorLogic;
%shared_ptr(openplx::Sensors::AccelerometerLogic);
%shared_ptr(openplx::Sensors::AccelerometerSensingDistortion);
%shared_ptr(openplx::Sensors::AccelerometerSignalGaussianNoise);
%shared_ptr(openplx::Sensors::AccelerometerSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::Distortion);
%shared_ptr(openplx::Sensors::GyroscopeLogic);
%shared_ptr(openplx::Sensors::GyroscopeSensingDistortion);
%shared_ptr(openplx::Sensors::GyroscopeSignalGaussianNoise);
%shared_ptr(openplx::Sensors::GyroscopeSignalLinearAccelectionEffect);
%shared_ptr(openplx::Sensors::GyroscopeSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS0);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS1);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OS2);
%shared_ptr(openplx::Sensors::Library::LIDARs::Ouster::OSDome);
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM150);
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM310);
%shared_ptr(openplx::Sensors::Library::LIDARs::SICK::TIM781);
%shared_ptr(openplx::Sensors::Library::LIDARs::Velodyne::VLP16);
%shared_ptr(openplx::Sensors::LidarDetectionDistanceGaussianNoise);
%shared_ptr(openplx::Sensors::LidarLogic);
%shared_ptr(openplx::Sensors::LidarSensingDistortion);
%shared_ptr(openplx::Sensors::MagnetometerLogic);
%shared_ptr(openplx::Sensors::MagnetometerSensingDistortion);
%shared_ptr(openplx::Sensors::MagnetometerSignalGaussianNoise);
%shared_ptr(openplx::Sensors::MagnetometerSignalSpectralGaussianNoise);
%shared_ptr(openplx::Sensors::Optics::BeamDivergence);
%shared_ptr(openplx::Sensors::Optics::ConicalBeamDivergence);
%shared_ptr(openplx::Sensors::Optics::HorizontalSweepRaySource);
%shared_ptr(openplx::Sensors::Optics::RayEmissionAngleGaussianNoise);
%shared_ptr(openplx::Sensors::Optics::RayEmissionDistortion);
%shared_ptr(openplx::Sensors::Optics::RaySource);
%shared_ptr(openplx::Sensors::Optics::Traits::BeamEmitter);
%shared_ptr(openplx::Sensors::Optics::Traits::DistortedRayEmission);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarHorizontalResolution1024);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarHorizontalResolution2048);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarHorizontalResolution512);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarVerticalResolution128);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarVerticalResolution32);
%shared_ptr(openplx::Sensors::Optics::Traits::LidarVerticalResolution64);
%shared_ptr(openplx::Sensors::Optics::Traits::PulsedBeamEmitter);
%shared_ptr(openplx::Sensors::Optics::Traits::RayEmitter);
%shared_ptr(openplx::Sensors::PulsedLidarLogic);
%shared_ptr(openplx::Sensors::SensorLogic);
%shared_ptr(openplx::Sensors::Signals::AccelerometerOutput);
%shared_ptr(openplx::Sensors::Signals::GyroscopeOutput);
%shared_ptr(openplx::Sensors::Signals::LidarOutput);
%shared_ptr(openplx::Sensors::Signals::LidarOutputField);
%shared_ptr(openplx::Sensors::Signals::MagnetometerOutput);
%shared_ptr(openplx::Sensors::Signals::SensorOutputSignal);
%shared_ptr(openplx::Sensors::Signals::TriaxialOutputField);
%shared_ptr(openplx::Sensors::Traits::LidarFrequency05);
%shared_ptr(openplx::Sensors::Traits::LidarFrequency10);
%shared_ptr(openplx::Sensors::Traits::LidarFrequency15);
%shared_ptr(openplx::Sensors::Traits::LidarFrequency20);
%shared_ptr(openplx::Sensors::Traits::MateAttachment);
%shared_ptr(openplx::Sensors::Traits::MateConnectorAttachment);
%shared_ptr(openplx::Sensors::TriaxialRange);
%shared_ptr(openplx::Sensors::TriaxialSensorLogic);
OPENPLX_TRAIT(BeamEmitter_TraitProxy, BeamEmitter, openplx::Sensors::Optics::Traits::BeamEmitter);
OPENPLX_TRAIT(DistortedRayEmission_TraitProxy, DistortedRayEmission, openplx::Sensors::Optics::Traits::DistortedRayEmission);
OPENPLX_TRAIT(LidarHorizontalResolution1024_TraitProxy, LidarHorizontalResolution1024, openplx::Sensors::Optics::Traits::LidarHorizontalResolution1024);
OPENPLX_TRAIT(LidarHorizontalResolution2048_TraitProxy, LidarHorizontalResolution2048, openplx::Sensors::Optics::Traits::LidarHorizontalResolution2048);
OPENPLX_TRAIT(LidarHorizontalResolution512_TraitProxy, LidarHorizontalResolution512, openplx::Sensors::Optics::Traits::LidarHorizontalResolution512);
OPENPLX_TRAIT(LidarVerticalResolution128_TraitProxy, LidarVerticalResolution128, openplx::Sensors::Optics::Traits::LidarVerticalResolution128);
OPENPLX_TRAIT(LidarVerticalResolution32_TraitProxy, LidarVerticalResolution32, openplx::Sensors::Optics::Traits::LidarVerticalResolution32);
OPENPLX_TRAIT(LidarVerticalResolution64_TraitProxy, LidarVerticalResolution64, openplx::Sensors::Optics::Traits::LidarVerticalResolution64);
OPENPLX_TRAIT(PulsedBeamEmitter_TraitProxy, PulsedBeamEmitter, openplx::Sensors::Optics::Traits::PulsedBeamEmitter);
OPENPLX_TRAIT(RayEmitter_TraitProxy, RayEmitter, openplx::Sensors::Optics::Traits::RayEmitter);
OPENPLX_TRAIT(LidarFrequency05_TraitProxy, LidarFrequency05, openplx::Sensors::Traits::LidarFrequency05);
OPENPLX_TRAIT(LidarFrequency10_TraitProxy, LidarFrequency10, openplx::Sensors::Traits::LidarFrequency10);
OPENPLX_TRAIT(LidarFrequency15_TraitProxy, LidarFrequency15, openplx::Sensors::Traits::LidarFrequency15);
OPENPLX_TRAIT(LidarFrequency20_TraitProxy, LidarFrequency20, openplx::Sensors::Traits::LidarFrequency20);
OPENPLX_TRAIT(MateAttachment_TraitProxy, MateAttachment, openplx::Sensors::Traits::MateAttachment);
OPENPLX_TRAIT(MateConnectorAttachment_TraitProxy, MateConnectorAttachment, openplx::Sensors::Traits::MateConnectorAttachment);
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::AccelerometerLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::AccelerometerSensingDistortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::AccelerometerSignalGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::AccelerometerSignalSpectralGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Distortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::GyroscopeLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::GyroscopeSensingDistortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::GyroscopeSignalGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::GyroscopeSignalLinearAccelectionEffect)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::GyroscopeSignalSpectralGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::Ouster::OS0)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::Ouster::OS1)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::Ouster::OS2)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::Ouster::OSDome)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::SICK::TIM150)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::SICK::TIM310)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::SICK::TIM781)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Library::LIDARs::Velodyne::VLP16)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::LidarDetectionDistanceGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::LidarLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::LidarSensingDistortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::MagnetometerLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::MagnetometerSensingDistortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::MagnetometerSignalGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::MagnetometerSignalSpectralGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::BeamDivergence)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::ConicalBeamDivergence)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::HorizontalSweepRaySource)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::RayEmissionAngleGaussianNoise)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::RayEmissionDistortion)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Optics::RaySource)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::PulsedLidarLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::SensorLogic)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::AccelerometerOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::GyroscopeOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::LidarOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::LidarOutputField)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::MagnetometerOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::SensorOutputSignal)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::Signals::TriaxialOutputField)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::TriaxialRange)
OPENPLX_FIX_DOWNCASTING(openplx::Sensors::TriaxialSensorLogic)
%typemap(csimports) openplx::Sensors::AccelerometerLogic "
/* Workaround for missing namespaces on interfaces */
using MateConnectorAttachment = openplx.Sensors.Traits.MateConnectorAttachment;
";
%typemap(csimports) openplx::Sensors::GyroscopeLogic "
/* Workaround for missing namespaces on interfaces */
using MateConnectorAttachment = openplx.Sensors.Traits.MateConnectorAttachment;
";
%typemap(csimports) openplx::Sensors::LidarLogic "
/* Workaround for missing namespaces on interfaces */
using MateConnectorAttachment = openplx.Sensors.Traits.MateConnectorAttachment;
";
%typemap(csimports) openplx::Sensors::MagnetometerLogic "
/* Workaround for missing namespaces on interfaces */
using MateConnectorAttachment = openplx.Sensors.Traits.MateConnectorAttachment;
";
%typemap(csimports) openplx::Sensors::Optics::Traits::BeamEmitter "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Sensors::Optics::Traits::PulsedBeamEmitter "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Sensors::PulsedLidarLogic "
/* Workaround for missing namespaces on interfaces */
using RayEmitter = openplx.Sensors.Optics.Traits.RayEmitter;
using BeamEmitter = openplx.Sensors.Optics.Traits.BeamEmitter;
using PulsedBeamEmitter = openplx.Sensors.Optics.Traits.PulsedBeamEmitter;
using DistortedRayEmission = openplx.Sensors.Optics.Traits.DistortedRayEmission;
";
%include "openplx/Sensors/SensorLogic.h"
%include "openplx/Sensors/TriaxialSensorLogic.h"
%include "openplx/Sensors/Traits/MateConnectorAttachment.h"
%include "openplx/Sensors/AccelerometerLogic.h"
%include "openplx/Sensors/Distortion.h"
%include "openplx/Sensors/AccelerometerSensingDistortion.h"
%include "openplx/Sensors/AccelerometerSignalGaussianNoise.h"
%include "openplx/Sensors/AccelerometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/GyroscopeLogic.h"
%include "openplx/Sensors/GyroscopeSensingDistortion.h"
%include "openplx/Sensors/GyroscopeSignalGaussianNoise.h"
%include "openplx/Sensors/GyroscopeSignalLinearAccelectionEffect.h"
%include "openplx/Sensors/GyroscopeSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS0.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS1.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS2.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OSDome.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM150.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM310.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM781.h"
%include "openplx/Sensors/Library/LIDARs/Velodyne/VLP16.h"
%include "openplx/Sensors/LidarSensingDistortion.h"
%include "openplx/Sensors/LidarDetectionDistanceGaussianNoise.h"
%include "openplx/Sensors/LidarLogic.h"
%include "openplx/Sensors/MagnetometerLogic.h"
%include "openplx/Sensors/MagnetometerSensingDistortion.h"
%include "openplx/Sensors/MagnetometerSignalGaussianNoise.h"
%include "openplx/Sensors/MagnetometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/Optics/BeamDivergence.h"
%include "openplx/Sensors/Optics/ConicalBeamDivergence.h"
%include "openplx/Sensors/Optics/RaySource.h"
%include "openplx/Sensors/Optics/HorizontalSweepRaySource.h"
%include "openplx/Sensors/Optics/RayEmissionDistortion.h"
%include "openplx/Sensors/Optics/RayEmissionAngleGaussianNoise.h"
%include "openplx/Sensors/Optics/Traits/RayEmitter.h"
%include "openplx/Sensors/Optics/Traits/BeamEmitter.h"
%include "openplx/Sensors/Optics/Traits/DistortedRayEmission.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution1024.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution2048.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution512.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution128.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution32.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution64.h"
%include "openplx/Sensors/Optics/Traits/PulsedBeamEmitter.h"
%include "openplx/Sensors/PulsedLidarLogic.h"
%include "openplx/Sensors/Signals/AccelerometerOutput.h"
%include "openplx/Sensors/Signals/GyroscopeOutput.h"
%include "openplx/Sensors/Signals/LidarOutput.h"
%include "openplx/Sensors/Signals/LidarOutputField.h"
%include "openplx/Sensors/Signals/MagnetometerOutput.h"
%include "openplx/Sensors/Signals/SensorOutputSignal.h"
%include "openplx/Sensors/Signals/TriaxialOutputField.h"
%include "openplx/Sensors/Traits/LidarFrequency05.h"
%include "openplx/Sensors/Traits/LidarFrequency10.h"
%include "openplx/Sensors/Traits/LidarFrequency15.h"
%include "openplx/Sensors/Traits/LidarFrequency20.h"
%include "openplx/Sensors/Traits/MateAttachment.h"
%include "openplx/Sensors/TriaxialRange.h"
%ignore Sensors_register_factories;
%include <openplx/Sensors/Sensors_all.h>
%inline {
    void Sensors_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Sensors_register_factories(eval_ctx);
    }
}
%template(SensorsAccelerometerLogicVector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerLogic>>;
%template(SensorsAccelerometerSensingDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSensingDistortion>>;
%template(SensorsAccelerometerSignalGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalGaussianNoise>>;
%template(SensorsAccelerometerSignalSpectralGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::AccelerometerSignalSpectralGaussianNoise>>;
%template(SensorsDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::Distortion>>;
%template(SensorsGyroscopeLogicVector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeLogic>>;
%template(SensorsGyroscopeSensingDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSensingDistortion>>;
%template(SensorsGyroscopeSignalGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalGaussianNoise>>;
%template(SensorsGyroscopeSignalLinearAccelectionEffectVector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalLinearAccelectionEffect>>;
%template(SensorsGyroscopeSignalSpectralGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::GyroscopeSignalSpectralGaussianNoise>>;
%template(SensorsLibraryLIDARsOusterOS0Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS0>>;
%template(SensorsLibraryLIDARsOusterOS1Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS1>>;
%template(SensorsLibraryLIDARsOusterOS2Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OS2>>;
%template(SensorsLibraryLIDARsOusterOSDomeVector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Ouster::OSDome>>;
%template(SensorsLibraryLIDARsSICKTIM150Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM150>>;
%template(SensorsLibraryLIDARsSICKTIM310Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM310>>;
%template(SensorsLibraryLIDARsSICKTIM781Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::SICK::TIM781>>;
%template(SensorsLibraryLIDARsVelodyneVLP16Vector) std::vector<std::shared_ptr<openplx::Sensors::Library::LIDARs::Velodyne::VLP16>>;
%template(SensorsLidarDetectionDistanceGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::LidarDetectionDistanceGaussianNoise>>;
%template(SensorsLidarLogicVector) std::vector<std::shared_ptr<openplx::Sensors::LidarLogic>>;
%template(SensorsLidarSensingDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::LidarSensingDistortion>>;
%template(SensorsMagnetometerLogicVector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerLogic>>;
%template(SensorsMagnetometerSensingDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSensingDistortion>>;
%template(SensorsMagnetometerSignalGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalGaussianNoise>>;
%template(SensorsMagnetometerSignalSpectralGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::MagnetometerSignalSpectralGaussianNoise>>;
%template(SensorsOpticsBeamDivergenceVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::BeamDivergence>>;
%template(SensorsOpticsConicalBeamDivergenceVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::ConicalBeamDivergence>>;
%template(SensorsOpticsHorizontalSweepRaySourceVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::HorizontalSweepRaySource>>;
%template(SensorsOpticsRayEmissionAngleGaussianNoiseVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionAngleGaussianNoise>>;
%template(SensorsOpticsRayEmissionDistortionVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>>;
%template(SensorsOpticsRaySourceVector) std::vector<std::shared_ptr<openplx::Sensors::Optics::RaySource>>;
%template(SensorsPulsedLidarLogicVector) std::vector<std::shared_ptr<openplx::Sensors::PulsedLidarLogic>>;
%template(SensorsSensorLogicVector) std::vector<std::shared_ptr<openplx::Sensors::SensorLogic>>;
%template(SensorsSignalsAccelerometerOutputVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::AccelerometerOutput>>;
%template(SensorsSignalsGyroscopeOutputVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::GyroscopeOutput>>;
%template(SensorsSignalsLidarOutputVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutput>>;
%template(SensorsSignalsLidarOutputFieldVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::LidarOutputField>>;
%template(SensorsSignalsMagnetometerOutputVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::MagnetometerOutput>>;
%template(SensorsSignalsSensorOutputSignalVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>>;
%template(SensorsSignalsTriaxialOutputFieldVector) std::vector<std::shared_ptr<openplx::Sensors::Signals::TriaxialOutputField>>;
%template(SensorsTriaxialRangeVector) std::vector<std::shared_ptr<openplx::Sensors::TriaxialRange>>;
%template(SensorsTriaxialSensorLogicVector) std::vector<std::shared_ptr<openplx::Sensors::TriaxialSensorLogic>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsAccelerometerLogic, openplx::Sensors::AccelerometerLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsAccelerometerSensingDistortion, openplx::Sensors::AccelerometerSensingDistortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsAccelerometerSignalGaussianNoise, openplx::Sensors::AccelerometerSignalGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsAccelerometerSignalSpectralGaussianNoise, openplx::Sensors::AccelerometerSignalSpectralGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsDistortion, openplx::Sensors::Distortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsGyroscopeLogic, openplx::Sensors::GyroscopeLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsGyroscopeSensingDistortion, openplx::Sensors::GyroscopeSensingDistortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsGyroscopeSignalGaussianNoise, openplx::Sensors::GyroscopeSignalGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsGyroscopeSignalLinearAccelectionEffect, openplx::Sensors::GyroscopeSignalLinearAccelectionEffect)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsGyroscopeSignalSpectralGaussianNoise, openplx::Sensors::GyroscopeSignalSpectralGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsOusterOS0, openplx::Sensors::Library::LIDARs::Ouster::OS0)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsOusterOS1, openplx::Sensors::Library::LIDARs::Ouster::OS1)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsOusterOS2, openplx::Sensors::Library::LIDARs::Ouster::OS2)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsOusterOSDome, openplx::Sensors::Library::LIDARs::Ouster::OSDome)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsSICKTIM150, openplx::Sensors::Library::LIDARs::SICK::TIM150)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsSICKTIM310, openplx::Sensors::Library::LIDARs::SICK::TIM310)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsSICKTIM781, openplx::Sensors::Library::LIDARs::SICK::TIM781)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLibraryLIDARsVelodyneVLP16, openplx::Sensors::Library::LIDARs::Velodyne::VLP16)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLidarDetectionDistanceGaussianNoise, openplx::Sensors::LidarDetectionDistanceGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLidarLogic, openplx::Sensors::LidarLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsLidarSensingDistortion, openplx::Sensors::LidarSensingDistortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsMagnetometerLogic, openplx::Sensors::MagnetometerLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsMagnetometerSensingDistortion, openplx::Sensors::MagnetometerSensingDistortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsMagnetometerSignalGaussianNoise, openplx::Sensors::MagnetometerSignalGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsMagnetometerSignalSpectralGaussianNoise, openplx::Sensors::MagnetometerSignalSpectralGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsBeamDivergence, openplx::Sensors::Optics::BeamDivergence)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsConicalBeamDivergence, openplx::Sensors::Optics::ConicalBeamDivergence)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsHorizontalSweepRaySource, openplx::Sensors::Optics::HorizontalSweepRaySource)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsRayEmissionAngleGaussianNoise, openplx::Sensors::Optics::RayEmissionAngleGaussianNoise)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsRayEmissionDistortion, openplx::Sensors::Optics::RayEmissionDistortion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsOpticsRaySource, openplx::Sensors::Optics::RaySource)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsPulsedLidarLogic, openplx::Sensors::PulsedLidarLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSensorLogic, openplx::Sensors::SensorLogic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsAccelerometerOutput, openplx::Sensors::Signals::AccelerometerOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsGyroscopeOutput, openplx::Sensors::Signals::GyroscopeOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsLidarOutput, openplx::Sensors::Signals::LidarOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsLidarOutputField, openplx::Sensors::Signals::LidarOutputField)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsMagnetometerOutput, openplx::Sensors::Signals::MagnetometerOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsSensorOutputSignal, openplx::Sensors::Signals::SensorOutputSignal)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsSignalsTriaxialOutputField, openplx::Sensors::Signals::TriaxialOutputField)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsTriaxialRange, openplx::Sensors::TriaxialRange)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalSensorsTriaxialSensorLogic, openplx::Sensors::TriaxialSensorLogic)
