/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/export.h>

#include <agx/Singleton.h>
#include <agx/BitState.h>

namespace agxSensor
{
  /**
  Utility functions used for configuration of the lower level raytracing functionality of agxSensor.
  */
  class AGXSENSOR_EXPORT RtConfig
  {
    public:
      /**
      \return true if raytrace (RTX) is supported by this device
      */
      static bool isRaytraceSupported();

      /**
      Checks if raytracing is supported on this device/platform. If not, a warning is issued once.
      */
      static bool verifyRaytraceSupported();

      /**
      \return index of the hardware device currently in use for raytracing, or -1 if raytracing is not
      supported on this device/platform.
      */
      static int getRaytraceDevice();

      /**
      Attempts to set the hardware device to use to the one with the specified index.
      \param deviceIndex - index of the compute enabled hardware device to use for raytracing
      \return true if the hardware device is successfully set
      */
      static bool setRaytraceDevice( int deviceIndex );

      /**
      Lists the devices available for raytracing.
      \return ordered list hardware compute device names
      */
      static std::vector<std::string> listRaytraceDevices();

      /**
      Resets internal state.
      */
      static void cleanup();

      DOXYGEN_START_INTERNAL_BLOCK()

    private:
      enum RaytraceStateFlag : agx::UInt16
      {
        UPDATED = 1 << 0,
        SUPPORTED = 1 << 1,
        WARNING_ISSUED = 1 << 2,
      };

      using RaytraceState = agx::BitState<RaytraceStateFlag>;

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      static RaytraceState s_raytraceState;
  };
}
