/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once
#include <agxSensor/RaytraceSystemNodeProxy.h>

#include <agx/Range.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES(LidarRayRange);

  /**
  Start and end range of each lidar ray, default [0, "infinity").
  */
  class AGXSENSOR_EXPORT LidarRayRange : public IRtSystemNode
  {
    public:
      /**
      Default constructor with default range [0, infinity).
      */
      LidarRayRange() = default;

      /**
      Construct given range [start, end].
      \param range - range of each lidar ray
      */
      explicit LidarRayRange(agx::RangeReal32 range);

      /**
      Set new range [start, end].
      \param range - new range of each lidar ray
      */
      void setRange(agx::RangeReal32 range);

      /**
      \return the current range of each lidar ray
      */
      agx::RangeReal32 getRange() const;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual RtNode* createNode() override;
      virtual void synchronize(RtNode* node, const CallbackData& data) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::LidarRayRange );

    private:
      RtNode* updateRange(RtNode* node);
      
      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::RangeReal32 m_range {0.f, agx::Real32Max };
  };
}
