%module(package="openplx") Vehicles
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="MachineModeling") <python/MachineModeling/MachineModelingModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%import(module="Simulation") <python/Simulation/SimulationModule.i>
%import(module="Visuals") <python/Visuals/VisualsModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Vehicles/Vehicles.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Vehicles(Vehicles_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Vehicles();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Vehicles();
OPENPLX_SWIG_BUNDLE_VECTORS_Vehicles();
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Suspensions/Base.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Base.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Chassis/Articulated/Interfaces/SingleJoint.h"
%include "openplx/Vehicles/Steering/Base.h"
%include "openplx/Vehicles/Steering/Interfaces/Base.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Interfaces/Frames.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/DualActuator.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/ToFrames.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interfaces/ChassisAttachmentConnectors.h"
%include "openplx/Vehicles/Suspensions/Properties/WheelAxisFromUpForward.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Suspensions/Properties/Steering.h"
%include "openplx/Vehicles/Interfaces/UpForwardVectors.h"
%include "openplx/Vehicles/Base.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/Base.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%include "openplx/Vehicles/Steering/Articulated/Base.h"
%include "openplx/Vehicles/Steering/Interfaces/Ackermann.h"
%include "openplx/Vehicles/Steering/Interfaces/BellCrank.h"
%include "openplx/Vehicles/Steering/Interfaces/RackAndPinion.h"
%include "openplx/Vehicles/Wheels/Tire.h"
%include "openplx/Vehicles/Chassis/Articulated/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Single/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/DualCylinder.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Base.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/Base.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Chassis/Rigid/Base.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Steering/Articulated/DualActuator.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/RackAndPinion.h"
%include "openplx/Vehicles/Chassis/Articulated/SingleJoint.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/OneLink.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/LinearSpringDamper.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Base.h"
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/FourWheel/Base.h"
%include "openplx/Vehicles/Steering/Articulated/DualCylinder.h"
%include "openplx/Vehicles/Chassis/Articulated/Hinge.h"
%include "openplx/Vehicles/Chassis/Articulated/Universal.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Steering/Kinematic/Base.h"
%include "openplx/Vehicles/Suspensions/SingleMate/LinearSpringDamper.h"
%include "openplx/Vehicles/Tracks/System.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Steering/Kinematic/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/RackAndPinion.h"
%include "openplx/Vehicles/FourWheel/Properties/RearSuspension.h"
%include "openplx/Vehicles/FourWheel/Properties/FrontSuspensionSteering.h"
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
