%module(package="openplx") MachineModeling
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%import(module="Simulation") <python/Simulation/SimulationModule.i>
%import(module="Visuals") <python/Visuals/VisualsModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/MachineModeling/MachineModeling.i>
OPENPLX_SWIG_BUNDLE_RENAMES_MachineModeling(MachineModeling_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_MachineModeling();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_MachineModeling();
OPENPLX_SWIG_BUNDLE_VECTORS_MachineModeling();
%include "openplx/MachineModeling/Connections/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/Traits/Cylindrical.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/Base.h"
%include "openplx/MachineModeling/Components/Composite/Base.h"
%include "openplx/MachineModeling/Connections/Interfaces/FromTo.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/VelocityMotor.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/ForceMotor.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/CylinderVisual.h"
%include "openplx/MachineModeling/Actuators/Linear/Traits/RigidCylinderPart.h"
%include "openplx/MachineModeling/Bearings/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Link/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/RigidCylindrical.h"
%include "openplx/MachineModeling/Connections/Pivot/Traits/Axle.h"
%include "openplx/MachineModeling/Actuators/Linear/Base.h"
%include "openplx/MachineModeling/Connections/Universal/Base.h"
%include "openplx/MachineModeling/Connections/Pivot/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderPart.h"
%include "openplx/MachineModeling/Bearings/Pair.h"
%include "openplx/MachineModeling/Components/Composite/LinkPair.h"
%include "openplx/MachineModeling/Actuators/Linear/Distance.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Base.h"
%include "openplx/MachineModeling/Connections/Pivot/Hinge.h"
%include "openplx/MachineModeling/Actuators/Linear/Cylinder.h"
%include "openplx/MachineModeling/Connections/Pivot/Traits/Bearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Distance.h"
%include "openplx/MachineModeling/Connections/Pivot/HingedAxle.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Cylinder.h"
%include "openplx/MachineModeling/Connections/Pivot/Bearings.h"
%include "openplx/MachineModeling/Connections/Pivot/AxleBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedAxleBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderAxleBearings.h"
