%module(package="openplx") DriveTrain
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_RENAMES_DriveTrain(DriveTrain_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_DriveTrain();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_DriveTrain();
OPENPLX_SWIG_BUNDLE_VECTORS_DriveTrain();
%include "openplx/DriveTrain/VelocityRatioTorqueMultiplicationPair.h"
%include "openplx/DriveTrain/VelocityRatioGeometryFactorPair.h"
%include "openplx/DriveTrain/Traits/PowerGenerator.h"
%include "openplx/DriveTrain/TorqueMotor.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationInput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockUpInput.h"
%include "openplx/DriveTrain/Traits/FourStrokeEngine.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockedUpOutput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationOutput.h"
%include "openplx/DriveTrain/Traits/TwoStrokeEngine.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationInput.h"
%include "openplx/DriveTrain/RPMTorquePair.h"
%include "openplx/DriveTrain/ManualClutch.h"
%include "openplx/DriveTrain/ManualBrake.h"
%include "openplx/DriveTrain/Shaft.h"
%include "openplx/DriveTrain/Actuator.h"
%include "openplx/DriveTrain/Gear.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationOutput.h"
%include "openplx/DriveTrain/PowerSource.h"
%include "openplx/DriveTrain/GearBox.h"
%include "openplx/DriveTrain/Traits/RotationalPowerGenerator.h"
%include "openplx/DriveTrain/EmpiricalTorqueConverter.h"
%include "openplx/DriveTrain/AutomaticBrake.h"
%include "openplx/DriveTrain/Differential.h"
%include "openplx/DriveTrain/PrismaticActuator.h"
%include "openplx/DriveTrain/HingeActuator.h"
%include "openplx/DriveTrain/FlexibleGear.h"
%include "openplx/DriveTrain/ViscousGear.h"
%include "openplx/DriveTrain/AutomaticClutch.h"
%include "openplx/DriveTrain/InfinitePowerSource.h"
%include "openplx/DriveTrain/EmpiricalEngine.h"
%include "openplx/DriveTrain/MeanValueEngine.h"
%include "openplx/DriveTrain/Signals/TorqueConverterPumpTorqueOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterTurbineTorqueOutput.h"
%include "openplx/DriveTrain/MechanicalDriveTrains/TwoWheelTemplate.h"
%include "openplx/DriveTrain/TorqueLimitedSlipDifferential.h"
%include "openplx/DriveTrain/Engines/VolvoBMTD45B.h"
%include "openplx/DriveTrain/Engines/CatC17520.h"
%include "openplx/DriveTrain/Engines/CatC32ACERT.h"
%include "openplx/DriveTrain/Engines/JohnDeere6068HF485.h"
%include "openplx/DriveTrain/Engines/GMTruck.h"
%include "openplx/DriveTrain/Engines/VolvoT5.h"
%include "openplx/DriveTrain/Engines/VolvoD16E540.h"
%include "openplx/DriveTrain/Engines/SaabB234i.h"
%include "openplx/DriveTrain/Engines/ScaniaK310UB4X2Euro5.h"
%include "openplx/DriveTrain/Engines/VolvoTD73KD.h"
%include "openplx/DriveTrain/Engines/KomatsuWA47510.h"
%include "openplx/DriveTrain/Engines/DoosanDE08TIS.h"
%include "openplx/DriveTrain/Engines/CatC27.h"
