%module(package="openplx") Control
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Control/Control_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Control/Control.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Control(Control_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Control();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Control();
OPENPLX_SWIG_BUNDLE_VECTORS_Control();
%include "openplx/Control/Virtual/BroadcastInput.h"
%include "openplx/Control/Virtual/AffineTransform1DOutput.h"
%include "openplx/Control/Virtual/GroupOutput.h"
%include "openplx/Control/Virtual/AffineTransform1DInput.h"
