#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Steering/Kinematic/Interactions/Base.h>
#include <openplx/Vehicles/Steering/Interfaces/BellCrank.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model BellCrank */
namespace openplx::Vehicles::Steering::Kinematic::Interactions {
    /**
     * Bell-crank steering geometry.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT BellCrank : public openplx::Vehicles::Steering::Kinematic::Interactions::Base, public openplx::Vehicles::Steering::Interfaces::BellCrank {
        protected:
            double m_knuckle_angle;
            double m_knuckle_length;
            double m_initial_angle_right_tie_rod;
            double m_steering_column_distance;
            double m_gear;

        public:
            BellCrank();
            virtual ~BellCrank();
            double knuckle_angle() const override;
            double knuckle_length() const override;
            double initial_angle_right_tie_rod() const override;
            double steering_column_distance() const override;
            double gear() const override;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
