#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Base.h>
#include <openplx/Vehicles/Interfaces/UpForwardVectors.h>
#include <openplx/Vehicles/Wheels/Base.h>
#include <openplx/Vehicles/Suspensions/Base.h>
#include <openplx/Vehicles/Chassis/Rigid/Base.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::Vehicles::FourWheel {
    class OPENPLX_Vehicles_BUNDLE_EXPORT Base : public openplx::Vehicles::Base, public openplx::Vehicles::Interfaces::UpForwardVectors {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_up_vector;
            std::shared_ptr<openplx::Math::Vec3> m_forward_vector;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> m_front_left_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> m_front_right_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> m_rear_left_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> m_rear_right_wheel;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> m_front_left_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> m_front_right_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> m_rear_left_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> m_rear_right_suspension;
            std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base> m_chassis;

        public:
            Base();
            virtual ~Base();
            std::shared_ptr<openplx::Math::Vec3> up_vector() const override;
            std::shared_ptr<openplx::Math::Vec3> forward_vector() const override;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> front_left_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> front_right_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> rear_left_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Base> rear_right_wheel() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> front_left_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> front_right_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> rear_left_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Base> rear_right_suspension() const;
            std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base> chassis() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
