#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Simulation/SimulationBundleExport.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Simulation/GravitationalField.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Environment */
namespace openplx::Simulation {
    /**
     * An environment is a special type of a system. Just as a system it can contain multiple subsystems and bodies.
     * An environment also contains parameters that affect the environment of all those bodies and systems that are part
     * of it, such as the gravitational field. An important difference to remember is that an environment should never
     * be in a system or another environment.
     *
     * gravity - what type of gravitational field is used
     **/
    class OPENPLX_Simulation_BUNDLE_EXPORT Environment : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Simulation::GravitationalField> m_gravity;

        public:
            Environment();
            virtual ~Environment();
            std::shared_ptr<openplx::Simulation::GravitationalField> gravity() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
