#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/LidarLogic.h>
#include <openplx/Sensors/Optics/Traits/PulsedBeamEmitter.h>
#include <openplx/Sensors/Optics/Traits/DistortedRayEmission.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model PulsedLidarLogic */
namespace openplx::Sensors {
    /**
     *     Logical functioning of a pulsed lidar sensor.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT PulsedLidarLogic : public openplx::Sensors::LidarLogic, public openplx::Sensors::Optics::Traits::PulsedBeamEmitter, public openplx::Sensors::Optics::Traits::DistortedRayEmission {
        protected:
            std::shared_ptr<openplx::Sensors::Optics::RaySource> m_ray_source;
            std::shared_ptr<openplx::Sensors::Optics::BeamDivergence> m_beam_divergence;
            double m_wavelength;
            std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>> m_ray_emission_distortions;

        public:
            PulsedLidarLogic();
            virtual ~PulsedLidarLogic();
            std::shared_ptr<openplx::Sensors::Optics::RaySource> ray_source() const override;
            std::shared_ptr<openplx::Sensors::Optics::BeamDivergence> beam_divergence() const override;
            double wavelength() const override;
            std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>> ray_emission_distortions() const override;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
