#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Signals/Input.h>
#include <openplx/Physics/Signals/InputSignal.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RobotInput */
namespace openplx::Robotics::Signals {
    /**
     * A filter that accepts a RobotInputSignal and decomposes it into a RealInputSignal of the correct type for each target in targets.
     * targets contains the Signal Inputs to map to in order.
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT RobotInput : public openplx::Physics::Signals::Input {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Signals::Input>> m_targets;

        public:
            RobotInput();
            virtual ~RobotInput();
            std::vector<std::shared_ptr<openplx::Physics::Signals::Input>> targets() const;
            std::vector<std::shared_ptr<openplx::Physics::Signals::InputSignal>> process(std::shared_ptr<openplx::Physics::Signals::InputSignal> signal) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
