#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/Bodies/Inertia.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LinkData */
namespace openplx::Robotics::Links {
    class OPENPLX_Robotics_BUNDLE_EXPORT LinkData : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::Inertia> m_inertia;
            std::shared_ptr<openplx::Math::Vec3> m_start_position;
            std::shared_ptr<openplx::Math::Vec3> m_start_main_axis;
            std::shared_ptr<openplx::Math::Vec3> m_start_normal;
            std::shared_ptr<openplx::Math::Vec3> m_end_position;
            std::shared_ptr<openplx::Math::Vec3> m_end_main_axis;
            std::shared_ptr<openplx::Math::Vec3> m_end_normal;

        public:
            LinkData();
            virtual ~LinkData();
            std::shared_ptr<openplx::Physics3D::Bodies::Inertia> inertia() const;
            std::shared_ptr<openplx::Math::Vec3> start_position() const;
            std::shared_ptr<openplx::Math::Vec3> start_main_axis() const;
            std::shared_ptr<openplx::Math::Vec3> start_normal() const;
            std::shared_ptr<openplx::Math::Vec3> end_position() const;
            std::shared_ptr<openplx::Math::Vec3> end_main_axis() const;
            std::shared_ptr<openplx::Math::Vec3> end_normal() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
