#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/DriveTrain/Shaft.h>
#include <openplx/Robotics/Signals/Sensor.h>
#include <openplx/DriveTrain/Actuator.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CoupledJointDriveTrain */
namespace openplx::Robotics::Joints {
    /**
     * Implements a drive train coupling between two actuators,
     * including a sensor for position and velocity of the interconnecting shaft.
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT CoupledJointDriveTrain : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::DriveTrain::Shaft> m_shaft;
            std::shared_ptr<openplx::Robotics::Signals::Sensor> m_sensor;
            std::shared_ptr<openplx::DriveTrain::Actuator> m_primary_actuator;
            std::shared_ptr<openplx::DriveTrain::Actuator> m_mimic_actuator;

        public:
            CoupledJointDriveTrain();
            virtual ~CoupledJointDriveTrain();
            std::shared_ptr<openplx::DriveTrain::Shaft> shaft() const;
            std::shared_ptr<openplx::Robotics::Signals::Sensor> sensor() const;
            std::shared_ptr<openplx::DriveTrain::Actuator> primary_actuator() const;
            std::shared_ptr<openplx::DriveTrain::Actuator> mimic_actuator() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
