#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/InputSignal.h>
#include <openplx/Physics/Signals/Input.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RealInputSignal */
namespace openplx::Physics::Signals {
    class OPENPLX_Physics_BUNDLE_EXPORT RealInputSignal : public openplx::Physics::Signals::InputSignal {
        protected:
            double m_value;

        public:
            RealInputSignal();
            virtual ~RealInputSignal();
            double value() const;
            static std::shared_ptr<openplx::Physics::Signals::RealInputSignal> create(double value, std::shared_ptr<openplx::Physics::Signals::Input> target);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
