#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ConstraintRelaxationTimeDamping */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *         Relaxation time defines the mechanical damping in units of time to
     *         restore a violated state of.
     *         From the units of stiffness, linear[N/m] and angular [Nm/rad],
     *         and the units of mechanical damping, linear [N/(m/s)] and angular [Nm/(rad/s)],
     *         The units say that damping / stiffness = [s] which is the relaxation time.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT ConstraintRelaxationTimeDamping : public openplx::Physics::Interactions::Dissipation::DefaultDissipation {
        protected:
            double m_relaxation_time;

        public:
            ConstraintRelaxationTimeDamping();
            virtual ~ConstraintRelaxationTimeDamping();
            double relaxation_time() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
