#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AsymmetricLimitFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     Defines a constant maximum friction force, for linear dof's, or torque for angular dof's.
     *     for positive and negative relative directions.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT AsymmetricLimitFriction : public openplx::Physics::Interactions::Dissipation::DefaultFriction {
        protected:
            double m_positive_limit;
            double m_negative_limit;

        public:
            AsymmetricLimitFriction();
            virtual ~AsymmetricLimitFriction();
            double positive_limit() const;
            double negative_limit() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
