#pragma once

#include <memory>

namespace openplx {

    class Marshalling;

    namespace Physics::Signals {
        class Output;
    }

    class OutputHandler {
        public:
            virtual ~OutputHandler() = default;

            /**
             * If the marshalling has no buffer the output handler
             * should populate the size and offsets in the marshalling
             * fields and set the required buffer size.
             *
             * @returns true if the marshalling was updated correctly with the output state, false otherwise
             */
            virtual bool handle(
                const std::shared_ptr<Physics::Signals::Output>& output,
                const std::shared_ptr<Marshalling>& marshalling) = 0;
    };
}
