#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathBundleExport.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Math/Quat.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AffineTransform */
namespace openplx::Math {
    /**
     * A transform that can represent any combination of translation, rotation, and scale
     * from_axes - Returns a transform that 1: rotates from a pair (main = Z, normal = X) to a new pair (new_Z, new_X), and 2: translates to position.
     *             Observe that new_X must not be parallell to new_Z in order for the result to be correct.
     *             If new_X is not orthogonal to new_Z, new_X will be projected onto the plane orthogonal to new_Z.
     **/
    class OPENPLX_Math_BUNDLE_EXPORT AffineTransform : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_position;
            std::shared_ptr<openplx::Math::Quat> m_rotation;

        public:
            AffineTransform();
            virtual ~AffineTransform();
            std::shared_ptr<openplx::Math::Vec3> position() const;
            std::shared_ptr<openplx::Math::Quat> rotation() const;
            static std::shared_ptr<openplx::Math::AffineTransform> create();
            static std::shared_ptr<openplx::Math::AffineTransform> from(std::shared_ptr<openplx::Math::Vec3> p, std::shared_ptr<openplx::Math::Quat> r);
            static std::shared_ptr<openplx::Math::AffineTransform> from_axes(std::shared_ptr<openplx::Math::Vec3> new_Z, std::shared_ptr<openplx::Math::Vec3> new_X, std::shared_ptr<openplx::Math::Vec3> position);
            static std::shared_ptr<openplx::Math::AffineTransform> inverse_of(std::shared_ptr<openplx::Math::Vec3> p, std::shared_ptr<openplx::Math::Quat> r);
            std::shared_ptr<openplx::Math::AffineTransform> inverse() const;
            std::shared_ptr<openplx::Math::Vec3> transform_vec3_point(std::shared_ptr<openplx::Math::Vec3> in) const;
            std::shared_ptr<openplx::Math::Vec3> transform_vec3_vector(std::shared_ptr<openplx::Math::Vec3> in) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
