#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Connections/Base.h>
#include <openplx/MachineModeling/Connections/Interfaces/FromTo.h>
#include <openplx/Physics3D/Interactions/Hinge.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::MachineModeling::Connections::Pivot {
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Base : public openplx::MachineModeling::Connections::Base, public openplx::MachineModeling::Connections::Interfaces::FromTo {
        protected:
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_from;
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_to;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> m_hinge;

        public:
            Base();
            virtual ~Base();
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> from() const override;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> to() const override;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> hinge() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
