#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/MachineModeling/Bearings/Base.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Pair */
namespace openplx::MachineModeling::Bearings {
    /**
     *     A bearing pair, with defined separation.
     *     The left bearing is at half negative separation distance from the local origin
     *     along the common local_axis, equally the right is half positive separation distance.
     *     Snap is disabled for the two bearing mates.
     *     Instead a snap_mate will snap the pair at the center of the axle
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Pair : public openplx::Physics3D::System {
        protected:
            double m_separation;
            std::shared_ptr<openplx::Math::Vec3> m_local_axis;
            std::weak_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            std::shared_ptr<openplx::MachineModeling::Bearings::Base> m_left;
            std::shared_ptr<openplx::MachineModeling::Bearings::Base> m_right;

        public:
            Pair();
            virtual ~Pair();
            double separation() const;
            std::shared_ptr<openplx::Math::Vec3> local_axis() const;
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            std::shared_ptr<openplx::MachineModeling::Bearings::Base> left() const;
            std::shared_ptr<openplx::MachineModeling::Bearings::Base> right() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
