#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Components/Composite/Base.h>
#include <openplx/Physics/Interactions/Interaction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::MachineModeling::Actuators::Linear {
    /**
     *     Abstract model for a linear actuator. By using this in your model,
     *     you have the option to replace it with any linear actuator inheriting from this model.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Base : public openplx::MachineModeling::Components::Composite::Base {
        protected:
            double m_min_length;
            double m_stroke_length;
            std::shared_ptr<openplx::Physics::Interactions::Interaction> m_source;

        public:
            Base();
            virtual ~Base();
            double min_length() const;
            double stroke_length() const;
            std::shared_ptr<openplx::Physics::Interactions::Interaction> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
