#pragma once

#include <memory>
#include <unordered_set>
#include <stdint.h>
#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>

namespace openplx {
    /**
     * Invalidates duplicate symbols in the same document or the same model,
     * for these duplicates we don't report an error on the "first" duplicate.
     */
    class InvalidateLocalDuplicateSymbolsVisitor : private NodeVisitor {
        public:
            explicit InvalidateLocalDuplicateSymbolsVisitor(std::shared_ptr<ErrorReporter> error_reporter);
            void validate(const DocPtr& document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitMethodDeclaration(const MethodDeclPtr& method_declaration) override;

            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::unordered_set<std::string> m_symbols;
    };
}
