#pragma once

#include <string>
#include <filesystem>

namespace openplx::Internal
{
    /**
     * @brief Read contents of text file
     * @param path absolute or relative path to file
     * @return std::string with contents
     * @throws exception if file does not exist or cannot be read etc
     */
    std::string fileGetContents(const std::string& path);
    /**
     * @brief Read contents of text file
     * @param path absolute path to file, can be used with unicode string, e.g. u8string or u32string
     * @return std::string with contents
     * @throws exception if file does not exist or cannot be read etc
     */
    std::string fileGetContents(const std::filesystem::path& path);

#ifdef _WIN32
    const std::string path_sep(";");
#else
    const std::string path_sep(":");
#endif
}
