#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ScaniaK310UB4X2Euro5 */
namespace openplx::DriveTrain::Engines {
    /**
     *         Used in Scania Bus.
     *         Reference: https://www.scania.com/content/dam/scanianoe/market/au/products-and-services/buses-and-coaches/spec-sheets/SCA03642AxelCityBusSpecSheet_SAU2016-7-KCity_4x2_WEB.pdf
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT ScaniaK310UB4X2Euro5 : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            ScaniaK310UB4X2Euro5();
            virtual ~ScaniaK310UB4X2Euro5();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
