#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SaabB234i */
namespace openplx::DriveTrain::Engines {
    /**
     *         Saab 9000 passenger car B234i engine parameters. Source: Figure 4.4, Eriksson2014, Modelling and control of engines. This engine has been installed on the cars such as Saab 900 II, Saab 9000 I and Saab 9-3 I. Check the description of Saab H engine here: https://en.wikipedia.org/wiki/Saab_H_engine
     *         Reference: https://www.zemekoni.org/files/files/9000%202.1%20-%20Basic%20Engine%20B234%20M1990-.pdf
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT SaabB234i : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            SaabB234i();
            virtual ~SaabB234i();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
