#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Control/ControlBundleExport.h>
#include <openplx/Control/ControlForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Input.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model BroadcastInput */
namespace openplx::Control::Virtual {
    /**
     * A virtual input control that broadcasts all fields to
     * a list of other inputs that must have matching fields.
     **/
    class OPENPLX_Control_BUNDLE_EXPORT BroadcastInput : public openplx::Physics::Signals::Input {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Signals::Input>> m_targets;

        public:
            BroadcastInput();
            virtual ~BroadcastInput();
            std::vector<std::shared_ptr<openplx::Physics::Signals::Input>> targets() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
