%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Physics1D::Bodies::Body;
%nspace openplx::Physics1D::Bodies::Inertia;
%nspace openplx::Physics1D::Bodies::Kinematics;
%nspace openplx::Physics1D::Bodies::LinearBody;
%nspace openplx::Physics1D::Bodies::LinearKinematics;
%nspace openplx::Physics1D::Bodies::RotationalBody;
%nspace openplx::Physics1D::Bodies::RotationalKinematics;
%nspace openplx::Physics1D::Interactions::LinearConnector;
%nspace openplx::Physics1D::Interactions::Mate;
%nspace openplx::Physics1D::Interactions::MateConnector;
%nspace openplx::Physics1D::Interactions::RotationalConnector;
%nspace openplx::Physics1D::Interactions::RotationalVelocityMotor;
%nspace openplx::Physics1D::Interactions::VelocityMotor;
%shared_ptr(openplx::Physics1D::Bodies::Body);
%shared_ptr(openplx::Physics1D::Bodies::Inertia);
%shared_ptr(openplx::Physics1D::Bodies::Kinematics);
%shared_ptr(openplx::Physics1D::Bodies::LinearBody);
%shared_ptr(openplx::Physics1D::Bodies::LinearKinematics);
%shared_ptr(openplx::Physics1D::Bodies::RotationalBody);
%shared_ptr(openplx::Physics1D::Bodies::RotationalKinematics);
%shared_ptr(openplx::Physics1D::Interactions::LinearConnector);
%shared_ptr(openplx::Physics1D::Interactions::Mate);
%shared_ptr(openplx::Physics1D::Interactions::MateConnector);
%shared_ptr(openplx::Physics1D::Interactions::RotationalConnector);
%shared_ptr(openplx::Physics1D::Interactions::RotationalVelocityMotor);
%shared_ptr(openplx::Physics1D::Interactions::VelocityMotor);
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::Body)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::Inertia)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::Kinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::LinearBody)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::LinearKinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::RotationalBody)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Bodies::RotationalKinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::LinearConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::Mate)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::MateConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::RotationalConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::RotationalVelocityMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics1D::Interactions::VelocityMotor)
%typemap(csimports) openplx::Physics1D::Bodies::RotationalBody "
/* Workaround for missing namespaces on interfaces */
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
using AngularVelocity1DOutputTrait = openplx.Physics.Signals.AngularVelocity1DOutputTrait;
";
%typemap(csimports) openplx::Physics1D::Interactions::RotationalVelocityMotor "
/* Workaround for missing namespaces on interfaces */
using AngularVelocity1DInputTrait = openplx.Physics.Signals.AngularVelocity1DInputTrait;
using AngularVelocity1DOutputTrait = openplx.Physics.Signals.AngularVelocity1DOutputTrait;
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using Torque1DInputTrait = openplx.Physics.Signals.Torque1DInputTrait;
using TorqueRangeInputTrait = openplx.Physics.Signals.TorqueRangeInputTrait;
using TorqueRangeOutputTrait = openplx.Physics.Signals.TorqueRangeOutputTrait;
";
%include "openplx/Physics1D/Bodies/Body.h"
%include "openplx/Physics1D/Bodies/Inertia.h"
%include "openplx/Physics1D/Bodies/Kinematics.h"
%include "openplx/Physics1D/Bodies/LinearBody.h"
%include "openplx/Physics1D/Bodies/LinearKinematics.h"
%include "openplx/Physics1D/Bodies/RotationalBody.h"
%include "openplx/Physics1D/Bodies/RotationalKinematics.h"
%include "openplx/Physics1D/Interactions/MateConnector.h"
%include "openplx/Physics1D/Interactions/LinearConnector.h"
%include "openplx/Physics1D/Interactions/Mate.h"
%include "openplx/Physics1D/Interactions/RotationalConnector.h"
%include "openplx/Physics1D/Interactions/VelocityMotor.h"
%include "openplx/Physics1D/Interactions/RotationalVelocityMotor.h"
%ignore Physics1D_register_factories;
%include <openplx/Physics1D/Physics1D_all.h>
%inline {
    void Physics1D_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Physics1D_register_factories(eval_ctx);
    }
}
%template(Physics1DBodiesBodyVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Body>>;
%template(Physics1DBodiesInertiaVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Inertia>>;
%template(Physics1DBodiesKinematicsVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>>;
%template(Physics1DBodiesLinearBodyVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>>;
%template(Physics1DBodiesLinearKinematicsVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>>;
%template(Physics1DBodiesRotationalBodyVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>>;
%template(Physics1DBodiesRotationalKinematicsVector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>>;
%template(Physics1DInteractionsLinearConnectorVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::LinearConnector>>;
%template(Physics1DInteractionsMateVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::Mate>>;
%template(Physics1DInteractionsMateConnectorVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::MateConnector>>;
%template(Physics1DInteractionsRotationalConnectorVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::RotationalConnector>>;
%template(Physics1DInteractionsRotationalVelocityMotorVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>>;
%template(Physics1DInteractionsVelocityMotorVector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesBody, openplx::Physics1D::Bodies::Body)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesInertia, openplx::Physics1D::Bodies::Inertia)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesKinematics, openplx::Physics1D::Bodies::Kinematics)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesLinearBody, openplx::Physics1D::Bodies::LinearBody)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesLinearKinematics, openplx::Physics1D::Bodies::LinearKinematics)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesRotationalBody, openplx::Physics1D::Bodies::RotationalBody)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DBodiesRotationalKinematics, openplx::Physics1D::Bodies::RotationalKinematics)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsLinearConnector, openplx::Physics1D::Interactions::LinearConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsMate, openplx::Physics1D::Interactions::Mate)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsMateConnector, openplx::Physics1D::Interactions::MateConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsRotationalConnector, openplx::Physics1D::Interactions::RotationalConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsRotationalVelocityMotor, openplx::Physics1D::Interactions::RotationalVelocityMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics1DInteractionsVelocityMotor, openplx::Physics1D::Interactions::VelocityMotor)
