%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Control/Control_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Control::Virtual::AffineTransform1DInput;
%nspace openplx::Control::Virtual::AffineTransform1DOutput;
%nspace openplx::Control::Virtual::BroadcastInput;
%nspace openplx::Control::Virtual::GroupOutput;
%shared_ptr(openplx::Control::Virtual::AffineTransform1DInput);
%shared_ptr(openplx::Control::Virtual::AffineTransform1DOutput);
%shared_ptr(openplx::Control::Virtual::BroadcastInput);
%shared_ptr(openplx::Control::Virtual::GroupOutput);
OPENPLX_FIX_DOWNCASTING(openplx::Control::Virtual::AffineTransform1DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Control::Virtual::AffineTransform1DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Control::Virtual::BroadcastInput)
OPENPLX_FIX_DOWNCASTING(openplx::Control::Virtual::GroupOutput)
%include "openplx/Control/Virtual/AffineTransform1DInput.h"
%include "openplx/Control/Virtual/AffineTransform1DOutput.h"
%include "openplx/Control/Virtual/BroadcastInput.h"
%include "openplx/Control/Virtual/GroupOutput.h"
%ignore Control_register_factories;
%include <openplx/Control/Control_all.h>
%inline {
    void Control_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Control_register_factories(eval_ctx);
    }
}
%template(ControlVirtualAffineTransform1DInputVector) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>>;
%template(ControlVirtualAffineTransform1DOutputVector) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>>;
%template(ControlVirtualBroadcastInputVector) std::vector<std::shared_ptr<openplx::Control::Virtual::BroadcastInput>>;
%template(ControlVirtualGroupOutputVector) std::vector<std::shared_ptr<openplx::Control::Virtual::GroupOutput>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalControlVirtualAffineTransform1DInput, openplx::Control::Virtual::AffineTransform1DInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalControlVirtualAffineTransform1DOutput, openplx::Control::Virtual::AffineTransform1DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalControlVirtualBroadcastInput, openplx::Control::Virtual::BroadcastInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalControlVirtualGroupOutput, openplx::Control::Virtual::GroupOutput)
