/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/RaytraceSystemNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES(RtRemoveRayMisses);

  /**
  This node will remove data from rays that doesn't hit any target.
  It has to be inserted before the output nodes but after any noise
  or similar node.
  */
  class AGXSENSOR_EXPORT RtRemoveRayMisses : public RtSystemNode
  {
    public:
      DOXYGEN_START_INTERNAL_BLOCK()

      RtRemoveRayMisses() = default;

    public:
      virtual ~RtRemoveRayMisses() = default;
      virtual RtNode* createNode() override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::RtRemoveRayMisses );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
