/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/MonoaxialSignalSystemNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( MonoaxialSignalResolution );

  /**
  Applies resolution binning to a monoaxial signal.
  */
  class AGXSENSOR_EXPORT MonoaxialSignalResolution : public IMonoaxialSignalSystemNode
  {
    public:
      /**
      Construct this monoaxial signal resolution binning node with the given \p resolution bin size.
      \param resolution - size of the resolution bins
      */
      MonoaxialSignalResolution( agx::Real resolution );

      /**
      Set the signal resolution.
      \param resolution - size of the resolution bins
      */
      void setResolution( agx::Real resolution );

      /**
      \return the size of the resolution bins
      */
      agx::Real getResolution() const;

      /**
      \return new, unique, monoaxial signal system node (proxy) of this implementation
      */
      virtual MonoaxialSignalSystemNodeRef createMonoaxialNodeProxy() override;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      MonoaxialSignalResolution();

      virtual void result( SystemNodeProxy& proxy, const CallbackData& data ) override;
      virtual void cleanup( SystemNodeProxy& proxy ) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::MonoaxialSignalResolution );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::Real m_resolution;
  };
}
