/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxSensor/LidarModel.h>
#include <agxSensor/LidarRayPatternGenerator.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES(LidarModelMechanicalRotation);

  /**
  Model of lidar that rotates laser emitter / reciever assembly continuously, with a
  given rotational frequency, vertical range, lidar ray range and horizontal / vertical 
  resolution.
  */
  class AGXSENSOR_EXPORT LidarModelMechanicalRotation : public LidarModel
  {
    public:
      /**
      Constructs the lidar and the ray pattern based on the configuration:
      \param verticalFov - veritcal field of view in radians x (horizontal) and y (vertical)
      \param resolution - resolution in radians x (horizontal) and y (vertical)
      \param frequency - number of revolutions per second
      \param range - lidar ray range
      \param properties - ray optical properties
      */
      LidarModelMechanicalRotation( agx::RangeReal32 verticalFov,
                                    agx::Vec2 resolution,
                                    agx::RangeReal32 range,
                                    agx::Real frequency,
                                    LidarProperties* properties = nullptr );

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::LidarModelMechanicalRotation );

    public:
      virtual ~LidarModelMechanicalRotation() = default;

    protected:
      LidarModelMechanicalRotation();
  };
}
